/* ********************************************************************************
# If you should have any comments, suggestions or improvements to these samples, 
# we welcome you to contact us at SampleCode@melissadata.com also please visit our 
# developers bulletin board at forum.melissadata.com.
# ******************************************************************************** */

/* ********************* LICENSE STRINGS **********************
#*     To unlock the full functionality of Phone Object,       *
#* please call a sales representative at 1-800-MELISSA ext. 3  *
#*         (1-800-635-4772 x3) for a license string.           *
#*  Phone Object will not function without a valid             *
#*      			  license string 			          	   *
#************************************************************* */


set pagesize 1000;
set long 20000;
set echo off;
set pages 999;
set serveroutput off;

truncate table log;
commit;

declare
  po pls_integer;
  bno varchar2(100);
  val varchar2(32767);
  ok integer;
begin

  insert into log values('starting');
  commit;

  po := mdPhoneCreate();
  insert into log values('created mdPhone object');
  commit;

  ok := mdPhoneSetLicenseString(po, 'SET_LICENSE_HERE');
  insert into log values('set license: ok=' || ok);
  commit;

  bno := mdPhoneGetBuildNumber(po);
  insert into log values('build number= ' || bno);
  commit;

  ok := mdPhoneInitialize(po, 'SET_PATH_HERE');
  insert into log values('init datafiles: error=' || ok);
  commit;

  val := mdPhoneGetInitErrorString(po);
  insert into log values('phone init error String: val=' || val);
  commit;

  val := mdPhoneGetDatabaseDate(po);
  insert into log values('database date = ' || val);
  commit;

  ok := mdPhoneLookup(po, '949-858-3000x1234', '');
  insert into log values('lookup: ok=' || ok);
  commit;

  val := mdPhoneGetResults(po);
  insert into log values('results=   ' || val);
  commit;

  val := mdPhoneGetAreaCode(po);
  insert into log values('area code= ' || val);
  commit;

  val := mdPhoneGetNewAreaCode(po);
  insert into log values('new ac=    ' || val);
  commit;

  val := mdPhoneGetPrefix(po);
  insert into log values('prefix=    ' || val);
  commit;

  val := mdPhoneGetSuffix(po);
  insert into log values('suffix=    ' || val);
  commit;

  val := mdPhoneGetExtension(po);
  insert into log values('ext=       ' || val);
  commit;

  val := mdPhoneGetCity(po);
  insert into log values('city=      ' || val);
  commit;

  val := mdPhoneGetState(po);
  insert into log values('state=     ' || val);
  commit;

  val := mdPhoneGetCountyName(po);
  insert into log values('county=    ' || val);
  commit;

  mdPhoneDestroy(po);
  insert into log values('destroyed mdPhone object');
  commit;

end;
.
run

select * from log;
